from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from .views import *

urlpatterns = [
    path('admin/', admin.site.urls),
    path("__reload__/", include("django_browser_reload.urls")),
    path('', include(('app.urls', 'app'), namespace='app')), 
    path('', include('subscription.urls')), 
    path('', include('dought.urls')), 
    # path('', include('question_bank.urls')), 
    path('social-auth/', include('social_django.urls', namespace='social')),
    path('ckeditor5/', include('django_ckeditor_5.urls')),

    path('signup/', signup_user, name='signup_user'),
    path('signup/save/', save_signup_user, name='save_signup_user'),
    path('login/', login_user, name='login_user'),
    path('logout/', logout_user, name='logout_user'),
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)








