from django import template

register = template.Library()

@register.filter
def get_star_range(value):
    """Returns a range based on a float rating (e.g., 4.5 → 4 stars)"""
    try:
        value = float(value)
        return range(int(round(value)))
    except:
        return range(0)
